# 🚀 Руководство по интеграции компонентов

## Быстрый старт

### Шаг 1: Создайте PHP файл страницы

Например, для главной страницы создайте `/index.php`:

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Главная");
?>

{# Ваш контент с компонентами #}

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

### Шаг 2: Вызовите компонент

```php
<?
$APPLICATION->IncludeComponent(
    "bitrix:catalog.section",  // Компонент
    "card",                    // Шаблон (папка в components/)
    array(                     // Параметры
        "IBLOCK_ID" => 2,
        "SECTION_ID" => $_REQUEST["SECTION_ID"]
    )
);
?>
```

### Шаг 3: Данные автоматически передаются в Twig

Компонент:
1. Получает данные из Bitrix
2. Обрабатывает в `result_modifier.php`
3. Сохраняет в `$arResult["TWIG_DATA"]`
4. Рендерит через `template.php` → Twig шаблон

---

## 📋 Таблица соответствия компонентов

| Компонент Bitrix | Шаблон | Twig файл | Описание |
|-----------------|--------|-----------|----------|
| `bitrix:catalog.section` | `card` | `catalog.twig` | Каталог товаров |
| `bitrix:catalog.element` | `catalog` | `product-detail.twig` | Детальная страница товара |
| `bitrix:catalog.section.list` | `card` | `partials/category-card.twig` | Список категорий |
| `bitrix:news.list` | `hero` | `partials/hero.twig` | Hero слайдер |
| `bitrix:news.list` | `features` | `partials/features.twig` | Блок преимуществ |
| `sport38:sale.basket.basket` | `.default` | `cart.twig` | Корзина |
| `sport38:sale.order.ajax` | `.default` | `checkout.twig` | Оформление заказа |
| `bitrix:sale.personal.order` | `.default` | `partials/personal/orders.twig` | Заказы |

---

## 🔧 Настройка параметров

### Каталог товаров

```php
array(
    "IBLOCK_ID" => 2,                    // ID инфоблока каталога
    "SECTION_ID" => $sectionId,          // ID секции
    "ELEMENT_SORT_FIELD" => "sort",      // Поле сортировки
    "ELEMENT_SORT_ORDER" => "asc",        // Направление сортировки
    "PAGE_ELEMENT_COUNT" => 20,           // Количество на странице
    "PROPERTY_CODE" => array(             // Свойства товаров
        "CML2_ARTICLE",
        "NEWPRODUCT",
        "SALELEADER"
    ),
    "PRICE_CODE" => array("BASE"),        // Типы цен
    "CACHE_TYPE" => "A",                  // Тип кеширования
    "CACHE_TIME" => "3600"                // Время кеширования
)
```

### Детальная страница товара

```php
array(
    "IBLOCK_ID" => 2,
    "ELEMENT_ID" => $elementId,           // ID товара
    "ELEMENT_CODE" => $code,              // Символьный код
    "PROPERTY_CODE" => array(             // Свойства
        "CML2_ARTICLE",
        "BRAND",
        "MORE_PHOTO"
    ),
    "PRICE_CODE" => array("BASE"),
    "USE_PRICE_COUNT" => "N",
    "CACHE_TYPE" => "A",
    "CACHE_TIME" => "3600"
)
```

---

## 📁 Структура файлов

```
/home/bitrix/www/
├── index.php                          # Главная страница
├── catalog/
│   ├── index.php                      # Каталог
│   └── detail.php                     # Детальная страница
├── personal/
│   ├── cart/
│   │   └── index.php                  # Корзина
│   └── order/
│       └── index.php                  # Оформление заказа
└── bitrix/templates/sport38-kant/
    ├── components/                    # Компоненты
    │   ├── bitrix/
    │   │   ├── catalog.section/
    │   │   │   └── card/
    │   │   │       ├── result_modifier.php
    │   │   │       └── template.php
    │   │   └── ...
    │   └── sport38/
    ├── template/                      # Twig шаблоны
    │   ├── catalog.twig
    │   ├── product-detail.twig
    │   └── ...
    └── include/
        └── twig_helper.php           # Helper класс
```

---

## 💡 Примеры использования

### Пример 1: Главная страница с Hero слайдером

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Главная");
?>

<div class="main-page">
    {# Hero слайдер #}
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:news.list",
        "hero",
        array(
            "IBLOCK_ID" => 16,
            "IBLOCK_TYPE" => "ad",
            "NEWS_COUNT" => 5,
            "SORT_BY1" => "SORT",
            "SORT_ORDER1" => "ASC",
            "FIELD_CODE" => array("PREVIEW_PICTURE"),
            "PROPERTY_CODE" => array("LINK"),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

### Пример 2: Каталог с фильтрами

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");

$sectionId = $_REQUEST["SECTION_ID"];
$APPLICATION->SetTitle("Каталог");
?>

<div class="catalog-page">
    {# Фильтры (если нужны) #}
    <?
    $APPLICATION->IncludeComponent(
        "sport38:catalog.smart.filter",
        ".default",
        array(
            "IBLOCK_ID" => 2,
            "SECTION_ID" => $sectionId,
            "FILTER_NAME" => "arrFilter",
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600"
        )
    );
    ?>
    
    {# Каталог товаров #}
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:catalog.section",
        "card",
        array(
            "IBLOCK_ID" => 2,
            "SECTION_ID" => $sectionId,
            "FILTER_NAME" => "arrFilter",
            "PAGE_ELEMENT_COUNT" => 20,
            "PROPERTY_CODE" => array("CML2_ARTICLE"),
            "PRICE_CODE" => array("BASE"),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## ⚠️ Важные замечания

1. **IBLOCK_ID** - обязательно укажите правильный ID вашего инфоблока
2. **Шаблон компонента** - должен совпадать с папкой в `components/`
3. **Кеширование** - используйте `CACHE_TYPE => "A"` для авто-кеширования
4. **Параметры** - все параметры передаются в массив третьего аргумента
5. **Данные в Twig** - автоматически доступны через переменные из `TWIG_DATA`

---

## 🔍 Отладка

### Проверка данных в result_modifier.php

```php
// В result_modifier.php добавьте:
error_log("TWIG_DATA: " . print_r($arResult["TWIG_DATA"], true));
```

### Проверка данных в Twig

```twig
{# В Twig шаблоне #}
{{ dump(items) }}
{{ dump(section) }}
```

---

## 📚 Дополнительные ресурсы

- [Документация Bitrix](https://dev.1c-bitrix.ru/api_help/)
- [Twig документация](https://twig.symfony.com/doc/)
- Примеры в `/bitrix/templates/sport38-kant/integration_examples.md`

