<?php
/**
 * Result modifier для списка категорий
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true) die();

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "categories" => array()
);

// Обработка секций
if (is_array($arResult["SECTIONS"]) && count($arResult["SECTIONS"]) > 0) {
    foreach ($arResult["SECTIONS"] as $section) {
        $category = array(
            "ID" => $section["ID"],
            "NAME" => $section["NAME"],
            "URL" => $section["SECTION_PAGE_URL"],
            "COUNT" => isset($section["ELEMENT_CNT"]) ? $section["ELEMENT_CNT"] : 0,
            "LARGE" => false // Можно добавить логику для больших карточек
        );
        
        // Изображение
        if (isset($section["PICTURE"]["SRC"])) {
            $category["IMAGE"] = $section["PICTURE"]["SRC"];
        } elseif (isset($section["~PICTURE"])) {
            $category["IMAGE"] = CFile::GetPath($section["~PICTURE"]);
        }
        
        $arResult["TWIG_DATA"]["categories"][] = $category;
    }
}

