<?php
/**
 * Result modifier для списка заказов в личном кабинете
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

require_once(__DIR__ . "/../../../../include/twig_helper.php");

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "orders" => array(),
    "breadcrumbs" => array()
);

// Обработка заказов
if (is_array($arResult["ORDERS"]) && count($arResult["ORDERS"]) > 0) {
    foreach ($arResult["ORDERS"] as $order) {
        $orderData = array(
            "ID" => $order["ID"],
            "ACCOUNT_NUMBER" => $order["ACCOUNT_NUMBER"],
            "DATE" => $order["DATE_INSERT_FORMATTED"],
            "STATUS" => array(
                "ID" => $order["STATUS_ID"],
                "NAME" => $order["STATUS_NAME"]
            ),
            "PRICE" => $order["PRICE_FORMATED"],
            "PAYED" => ($order["PAYED"] == "Y"),
            "CANCELED" => ($order["CANCELED"] == "Y"),
            "URL" => $order["URL_TO_DETAIL"]
        );
        
        $arResult["TWIG_DATA"]["orders"][] = $orderData;
    }
}

// Хлебные крошки
$arResult["TWIG_DATA"]["breadcrumbs"] = Sport38KantTwigHelper::prepareBreadcrumbs(
    array(),
    "Мои заказы"
);

