<?php
/**
 * Result modifier для корзины
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "items" => array(),
    "summary" => array(),
    "breadcrumbs" => array()
);

// Обработка товаров в корзине
if (is_array($arResult["GRID"]["ROWS"]) && count($arResult["GRID"]["ROWS"]) > 0) {
    foreach ($arResult["GRID"]["ROWS"] as $row) {
        $item = array(
            "ID" => $row["ID"],
            "PRODUCT_ID" => $row["PRODUCT_ID"],
            "NAME" => $row["NAME"],
            "QUANTITY" => $row["QUANTITY"],
            "URL" => isset($row["DETAIL_PAGE_URL"]) ? $row["DETAIL_PAGE_URL"] : ""
        );
        
        // Изображение
        if (isset($row["PREVIEW_PICTURE_SRC"])) {
            $item["IMAGE"] = $row["PREVIEW_PICTURE_SRC"];
        } elseif (isset($row["DETAIL_PICTURE_SRC"])) {
            $item["IMAGE"] = $row["DETAIL_PICTURE_SRC"];
        }
        
        // Цена
        if (isset($row["PRICE_FORMATED"])) {
            $item["PRICE_FORMATED"] = $row["PRICE_FORMATED"];
        }
        
        // Сумма
        if (isset($row["SUM"])) {
            $item["SUM_FORMATED"] = $row["SUM"];
        } elseif (isset($row["SUM_FORMATED"])) {
            $item["SUM_FORMATED"] = $row["SUM_FORMATED"];
        }
        
        // Свойства
        if (isset($row["PROPS"]) && is_array($row["PROPS"])) {
            $item["PROPERTIES"] = array();
            foreach ($row["PROPS"] as $prop) {
                if ($prop["CODE"] != "CATALOG.XML_ID" && $prop["CODE"] != "PRODUCT.XML_ID") {
                    $item["PROPERTIES"][] = array(
                        "NAME" => $prop["NAME"],
                        "VALUE" => $prop["VALUE"]
                    );
                }
            }
        }
        
        $arResult["TWIG_DATA"]["items"][] = $item;
    }
}

// Итого
if (isset($arResult["allSum"])) {
    $arResult["TWIG_DATA"]["summary"] = array(
        "SUBTOTAL" => isset($arResult["allSum_FORMATED"]) ? $arResult["allSum_FORMATED"] : $arResult["allSum"],
        "DELIVERY" => isset($arResult["DELIVERY_PRICE_FORMATED"]) ? $arResult["DELIVERY_PRICE_FORMATED"] : null,
        "DISCOUNT" => isset($arResult["DISCOUNT_PRICE_FORMATED"]) ? $arResult["DISCOUNT_PRICE_FORMATED"] : null,
        "TOTAL" => isset($arResult["allSum_FORMATED"]) ? $arResult["allSum_FORMATED"] : $arResult["allSum"]
    );
}

// Хлебные крошки
$arResult["TWIG_DATA"]["breadcrumbs"] = array(
    array("TITLE" => "Главная", "URL" => "/"),
    array("TITLE" => "Корзина", "URL" => null)
);

