<?php
/**
 * Helper для работы с Twig в шаблоне sport38-kant
 */

if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

class Sport38KantTwigHelper
{
    /**
     * Получить экземпляр Twig шаблона
     * @return \UP\Twig\Template|null
     */
    public static function getTemplate()
    {
        if (!\Bitrix\Main\Loader::includeModule("up.twig")) {
            return null;
        }
        
        $templatePath = __DIR__ . "/../template";
        return new \UP\Twig\Template($templatePath);
    }
    
    /**
     * Отобразить Twig шаблон
     * @param string $templateName Имя шаблона (например, "catalog.twig")
     * @param array $vars Переменные для шаблона
     * @return void
     */
    public static function display($templateName, $vars = array())
    {
        $template = self::getTemplate();
        if ($template) {
            $template->display($templateName, $vars);
        }
    }
    
    /**
     * Рендерить Twig шаблон и вернуть результат
     * @param string $templateName Имя шаблона
     * @param array $vars Переменные для шаблона
     * @return string
     */
    public static function render($templateName, $vars = array())
    {
        $template = self::getTemplate();
        if ($template) {
            return $template->render($templateName, $vars);
        }
        return "";
    }
    
    /**
     * Подготовить данные для хлебных крошек
     * @param array $path Массив путей из Bitrix
     * @param string $currentTitle Текущий заголовок
     * @return array
     */
    public static function prepareBreadcrumbs($path = array(), $currentTitle = "")
    {
        $breadcrumbs = array();
        
        // Добавляем главную
        $breadcrumbs[] = array(
            "TITLE" => "Главная",
            "URL" => "/"
        );
        
        // Добавляем пути
        if (is_array($path)) {
            foreach ($path as $item) {
                $breadcrumbs[] = array(
                    "TITLE" => isset($item["NAME"]) ? $item["NAME"] : (isset($item["TITLE"]) ? $item["TITLE"] : ""),
                    "URL" => isset($item["SECTION_PAGE_URL"]) ? $item["SECTION_PAGE_URL"] : (isset($item["URL"]) ? $item["URL"] : null)
                );
            }
        }
        
        // Добавляем текущую страницу
        if ($currentTitle) {
            $breadcrumbs[] = array(
                "TITLE" => $currentTitle,
                "URL" => null
            );
        }
        
        return $breadcrumbs;
    }
    
    /**
     * Подготовить данные о цене для Twig
     * @param array $priceData Данные цены из Bitrix
     * @return array
     */
    public static function preparePrice($priceData)
    {
        if (!is_array($priceData) || empty($priceData)) {
            return null;
        }
        
        $result = array(
            "VALUE" => isset($priceData["VALUE"]) ? floatval($priceData["VALUE"]) : 0,
            "DISCOUNT_VALUE" => isset($priceData["DISCOUNT_VALUE"]) ? floatval($priceData["DISCOUNT_VALUE"]) : (isset($priceData["VALUE"]) ? floatval($priceData["VALUE"]) : 0),
            "PRINT_VALUE" => isset($priceData["PRINT_VALUE"]) ? $priceData["PRINT_VALUE"] : "",
            "PRINT_DISCOUNT_VALUE" => isset($priceData["PRINT_DISCOUNT_VALUE"]) ? $priceData["PRINT_DISCOUNT_VALUE"] : (isset($priceData["PRINT_VALUE"]) ? $priceData["PRINT_VALUE"] : ""),
            "CURRENCY" => isset($priceData["CURRENCY"]) ? $priceData["CURRENCY"] : "RUB"
        );
        
        // Расчет скидки
        if ($result["VALUE"] > 0 && $result["DISCOUNT_VALUE"] < $result["VALUE"]) {
            $discountPercent = round((($result["VALUE"] - $result["DISCOUNT_VALUE"]) * 100) / $result["VALUE"]);
            if ($discountPercent > 0 && $discountPercent < 100) {
                $result["DISCOUNT_PERCENT"] = $discountPercent;
                $result["DISCOUNT"] = $discountPercent . "%";
            }
        }
        
        return $result;
    }
    
    /**
     * Подготовить изображение для Twig
     * @param array|int $picture Изображение из Bitrix (массив или ID)
     * @param string $defaultAlt Альтернативный текст по умолчанию
     * @return array|null
     */
    public static function prepareImage($picture, $defaultAlt = "")
    {
        if (empty($picture)) {
            return null;
        }
        
        // Если передан ID
        if (is_numeric($picture)) {
            $picture = CFile::GetFileArray($picture);
        }
        
        if (!is_array($picture) || empty($picture["SRC"])) {
            return null;
        }
        
        return array(
            "SRC" => $picture["SRC"],
            "SRC_SMALL" => isset($picture["SRC_SMALL"]) ? $picture["SRC_SMALL"] : $picture["SRC"],
            "ALT" => isset($picture["ALT"]) ? $picture["ALT"] : $defaultAlt,
            "TITLE" => isset($picture["TITLE"]) ? $picture["TITLE"] : $defaultAlt,
            "WIDTH" => isset($picture["WIDTH"]) ? intval($picture["WIDTH"]) : null,
            "HEIGHT" => isset($picture["HEIGHT"]) ? intval($picture["HEIGHT"]) : null
        );
    }
}

