# Примеры интеграции компонентов Bitrix

## 📋 Содержание
1. [Главная страница](#главная-страница)
2. [Каталог товаров](#каталог-товаров)
3. [Детальная страница товара](#детальная-страница-товара)
4. [Корзина](#корзина)
5. [Оформление заказа](#оформление-заказа)
6. [Личный кабинет](#личный-кабинет)

---

## Главная страница

### Файл: `/index.php`

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Главная страница");
?>

<div class="main-page">
    {# Hero слайдер #}
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:news.list",
        "hero",
        array(
            "IBLOCK_ID" => 16, // ID инфоблока с баннерами
            "IBLOCK_TYPE" => "ad",
            "NEWS_COUNT" => 5,
            "SORT_BY1" => "SORT",
            "SORT_ORDER1" => "ASC",
            "FIELD_CODE" => array("PREVIEW_PICTURE", "DETAIL_PICTURE"),
            "PROPERTY_CODE" => array("LINK", "IMAGE"),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600"
        )
    );
    ?>
    
    {# Блок преимуществ #}
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:news.list",
        "features",
        array(
            "IBLOCK_ID" => 17, // ID инфоблока с преимуществами
            "IBLOCK_TYPE" => "content",
            "NEWS_COUNT" => 4,
            "SORT_BY1" => "SORT",
            "SORT_ORDER1" => "ASC",
            "FIELD_CODE" => array("PREVIEW_TEXT"),
            "PROPERTY_CODE" => array("ICON"),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600"
        )
    );
    ?>
    
    {# Категории товаров #}
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:catalog.section.list",
        "card",
        array(
            "IBLOCK_ID" => 2, // ID инфоблока каталога
            "IBLOCK_TYPE" => "catalog",
            "SECTION_ID" => "",
            "SECTION_CODE" => "",
            "TOP_DEPTH" => 2,
            "SECTION_FIELDS" => array("PICTURE"),
            "SECTION_USER_FIELDS" => array(),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600",
            "CACHE_GROUPS" => "Y"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## Каталог товаров

### Файл: `/catalog/index.php`

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");

$sectionId = $_REQUEST["SECTION_ID"] ?: $_REQUEST["SECTION_CODE"];
$APPLICATION->SetTitle("Каталог товаров");
?>

<div class="catalog-page">
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:catalog.section",
        "card",
        array(
            "IBLOCK_ID" => 2,
            "IBLOCK_TYPE" => "catalog",
            "SECTION_ID" => $sectionId,
            "SECTION_CODE" => $_REQUEST["SECTION_CODE"],
            "ELEMENT_SORT_FIELD" => "sort",
            "ELEMENT_SORT_ORDER" => "asc",
            "ELEMENT_SORT_FIELD2" => "id",
            "ELEMENT_SORT_ORDER2" => "desc",
            "FILTER_NAME" => "arrFilter",
            "INCLUDE_SUBSECTIONS" => "Y",
            "SHOW_ALL_WO_SECTION" => "Y",
            "PAGE_ELEMENT_COUNT" => 20,
            "LINE_ELEMENT_COUNT" => 3,
            "PROPERTY_CODE" => array(
                0 => "CML2_ARTICLE",
                1 => "NEWPRODUCT",
                2 => "SALELEADER"
            ),
            "PRICE_CODE" => array(
                0 => "BASE"
            ),
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600",
            "CACHE_GROUPS" => "Y"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## Детальная страница товара

### Файл: `/catalog/detail.php` или через URL Rewrite

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");

$elementId = $_REQUEST["ELEMENT_ID"] ?: $_REQUEST["ELEMENT_CODE"];
$APPLICATION->SetTitle("Товар");
?>

<div class="product-detail-page">
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:catalog.element",
        "catalog",
        array(
            "IBLOCK_ID" => 2,
            "IBLOCK_TYPE" => "catalog",
            "ELEMENT_ID" => $elementId,
            "ELEMENT_CODE" => $_REQUEST["ELEMENT_CODE"],
            "PROPERTY_CODE" => array(
                0 => "CML2_ARTICLE",
                1 => "BRAND",
                2 => "MORE_PHOTO",
                3 => "SIZE",
                4 => "COLOR"
            ),
            "PRICE_CODE" => array(
                0 => "BASE"
            ),
            "USE_PRICE_COUNT" => "N",
            "SHOW_PRICE_COUNT" => "1",
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600",
            "CACHE_GROUPS" => "Y"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## Корзина

### Файл: `/personal/cart/index.php`

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Корзина");
?>

<div class="cart-page">
    <?
    $APPLICATION->IncludeComponent(
        "sport38:sale.basket.basket",
        ".default",
        array(
            "COLUMNS_LIST" => array(
                0 => "NAME",
                1 => "PRICE",
                2 => "QUANTITY",
                3 => "SUM",
                4 => "DELETE"
            ),
            "PATH_TO_ORDER" => "/personal/order/",
            "HIDE_COUPON" => "N",
            "PRICE_VAT_SHOW_VALUE" => "Y",
            "COUNT_DISCOUNT_4_ALL_QUANTITY" => "N",
            "USE_PREPAYMENT" => "N",
            "QUANTITY_FLOAT" => "N",
            "SET_TITLE" => "Y",
            "ACTION_VARIABLE" => "action",
            "OFFERS_PROPS" => array()
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## Оформление заказа

### Файл: `/personal/order/index.php`

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Оформление заказа");
?>

<div class="checkout-page">
    <?
    $APPLICATION->IncludeComponent(
        "sport38:sale.order.ajax",
        ".default",
        array(
            "PAY_FROM_ACCOUNT" => "N",
            "COUNT_DELIVERY_TAX" => "N",
            "COUNT_DISCOUNT_4_ALL_QUANTITY" => "N",
            "ONLY_FULL_PAY_FROM_ACCOUNT" => "N",
            "ALLOW_AUTO_REGISTER" => "Y",
            "SEND_NEW_USER_NOTIFY" => "Y",
            "DELIVERY_NO_AJAX" => "N",
            "TEMPLATE_LOCATION" => "popup",
            "DELIVERY_NO_SESSION" => "Y",
            "TEMPLATE_THEME" => "site",
            "DELIVERY_TO_PAYSYSTEM" => "d2p",
            "USE_PREPAYMENT" => "N",
            "SET_TITLE" => "Y"
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## Личный кабинет

### Файл: `/personal/orders/index.php`

```php
<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/header.php");
$APPLICATION->SetTitle("Мои заказы");
?>

<div class="personal-orders-page">
    <?
    $APPLICATION->IncludeComponent(
        "bitrix:sale.personal.order",
        ".default",
        array(
            "ACTIVE_DATE_FORMAT" => "d.m.Y",
            "SEF_MODE" => "N",
            "SEF_FOLDER" => "/personal/orders/",
            "CACHE_TYPE" => "A",
            "CACHE_TIME" => "3600",
            "CACHE_GROUPS" => "Y",
            "ORDERS_PER_PAGE" => "20",
            "PATH_TO_PAYMENT" => "/personal/orders/payment/",
            "PATH_TO_BASKET" => "/personal/cart/",
            "SET_TITLE" => "Y",
            "SAVE_IN_SESSION" => "Y",
            "NAV_TEMPLATE" => "",
            "CUSTOM_SELECT_PROPS" => array(),
            "HISTORIC_STATUSES" => array("F")
        )
    );
    ?>
</div>

<?
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/footer.php");
?>
```

---

## 🔄 Как это работает

### 1. Вызов компонента
```php
$APPLICATION->IncludeComponent(
    "bitrix:catalog.section",  // Имя компонента
    "card",                     // Шаблон компонента
    array(...)                  // Параметры
);
```

### 2. Обработка данных
- Компонент получает данные из Bitrix
- `result_modifier.php` преобразует данные в формат для Twig
- Данные сохраняются в `$arResult["TWIG_DATA"]`

### 3. Рендеринг
- `template.php` вызывает `Sport38KantTwigHelper::display()`
- Twig шаблон получает данные из `$arResult["TWIG_DATA"]`
- Готовый HTML выводится на страницу

---

## 📝 Важные моменты

1. **IBLOCK_ID** - нужно указать правильный ID инфоблока
2. **Шаблон компонента** - должен совпадать с папкой в `components/`
3. **Кеширование** - настройте `CACHE_TYPE` и `CACHE_TIME`
4. **Параметры** - все параметры передаются в массив третьего аргумента

---

## 🎯 Следующие шаги

1. Создайте PHP файлы для страниц (index.php, catalog/index.php и т.д.)
2. Настройте параметры компонентов под ваш сайт
3. Проверьте работу на реальных данных
4. Настройте URL Rewrite для красивых URL

