# Инструкция по установке на тестовом кластере

## 📦 Архивы для установки

1. **Шаблон**: `/home/bitrix/www/bitrix/templates/sport38-kant.zip` (142 KB)
2. **Модуль**: `/home/bitrix/www/bitrix/modules/sport38.kant.zip` (37 KB)

## 🚀 Порядок установки

### 1. Распаковка шаблона

```bash
cd /path/to/bitrix/templates
unzip sport38-kant.zip
chmod -R 755 sport38-kant
chown -R bitrix:bitrix sport38-kant
```

### 2. Распаковка модуля

```bash
cd /path/to/bitrix/modules
unzip sport38.kant.zip
chmod -R 755 sport38.kant
chown -R bitrix:bitrix sport38.kant
```

### 3. Установка модуля через админку Bitrix

1. Войдите в административную панель Bitrix
2. Перейдите: **Настройки → Управление структурой → Управление модулями**
3. Найдите модуль **"Sport38 Kant"** в списке
4. Нажмите **"Установить"**
5. Дождитесь завершения установки

### 4. Активация шаблона

1. Перейдите: **Настройки → Настройки продукта → Настройки сайтов**
2. Выберите нужный сайт
3. В разделе **"Шаблон сайта"** выберите **"Sport38 Kant (новый дизайн)"**
4. Сохраните изменения

### 5. Проверка зависимостей

Убедитесь, что установлены необходимые модули:
- `iblock` - Информационные блоки
- `catalog` - Торговый каталог
- `sale` - Интернет-магазин
- `main` - Главный модуль

### 6. Очистка кеша

```bash
# Очистка кеша Bitrix
rm -rf /path/to/bitrix/cache/*
rm -rf /path/to/bitrix/managed_cache/*
```

Или через админку: **Настройки → Производительность → Очистить кеш**

## ✅ Проверка установки

1. Откройте главную страницу сайта
2. Проверьте, что шаблон применяется корректно
3. Проверьте работу каталога товаров
4. Проверьте корзину и оформление заказа

## 📝 Дополнительные настройки

### Настройка компонентов

После установки может потребоваться настройка компонентов на страницах:
- Главная страница (`/pages/index.php`)
- Каталог (`/pages/catalog/index.php`)
- Корзина (`/pages/personal/cart/index.php`)
- Контакты (`/pages/contacts/index.php`)
- Бонусы (`/pages/bonus/index.php`)

### Миграция существующих страниц

Используйте скрипт миграции из шаблона:
```bash
cd /path/to/bitrix/templates/sport38-kant
bash migrate_pages.sh
```

## 🔧 Возможные проблемы

### Модуль не отображается в списке
- Проверьте права доступа к папке модуля (755)
- Проверьте наличие файла `install/index.php`
- Проверьте логи ошибок PHP

### Шаблон не применяется
- Проверьте права доступа к папке шаблона (755)
- Проверьте наличие файла `description.php`
- Очистите кеш Bitrix

### Ошибки в компонентах
- Проверьте, что модуль `sport38.kant` установлен
- Проверьте логи ошибок PHP
- Убедитесь, что все зависимости установлены

## 📞 Поддержка

При возникновении проблем проверьте:
1. Логи PHP: `/var/log/php-fpm/error.log` или `/var/log/apache2/error.log`
2. Логи Bitrix: через админку → **Настройки → Производительность → Логи**
3. Права доступа к файлам и папкам

---

**Дата создания**: 2024-12-22
**Версия шаблона**: 1.0
**Версия модуля**: 1.0.0

