# 🔄 Руководство по миграции с sport38.site на sport38.kant

## 📋 Общая информация

Модуль `sport38.kant` - это оптимизированная версия `sport38.site` для нового шаблона `sport38-kant`.

**ВАЖНО:** Модуль `sport38.site` остается без изменений и продолжает работать!

---

## 🚀 Установка модуля

### Шаг 1: Установка через админку

1. Зайдите в админку Bitrix
2. Настройки → Управление структурой → Управление модулями
3. Найдите "Sport38 Kant - Модуль для нового шаблона"
4. Нажмите "Установить"

### Шаг 2: Проверка установки

После установки модуль автоматически зарегистрирует все обработчики событий.

---

## 🔄 Миграция кода

### Изменение namespace

**Было:**
```php
use Sport38\Site\Price;
use Sport38\Site\Bonus;
use Sport38\Site\Cart;
```

**Стало:**
```php
use Sport38\Kant\Price;
use Sport38\Kant\Bonus;
use Sport38\Kant\Cart;
```

### Обновление компонентов

В файлах `result_modifier.php` компонентов шаблона `sport38-kant` уже используется новый модуль:

```php
<?php
if (\Bitrix\Main\Loader::includeModule('sport38.kant')) {
    use Sport38\Kant\Price;
    use Sport38\Kant\DiscountFlag;
    
    // Использование улучшенных методов
    $price = Price::getOptimal($item["PRICES"]);
    $discountPercent = Price::calculateDiscountPercent($originalPrice, $discountPrice);
}
```

---

## ✨ Новые возможности

### 1. Price::format()

Форматирование цены для отображения:

```php
$formatted = Price::format(1500.50, 'RUB');
// Результат: "1 500,50 руб."
```

### 2. Price::calculateDiscountPercent()

Расчет процента скидки:

```php
$percent = Price::calculateDiscountPercent(1000, 800);
// Результат: 20
```

### 3. Cart::isInCart()

Проверка наличия товара в корзине:

```php
if (Cart::isInCart($productId)) {
    // Товар уже в корзине
}
```

### 4. Cart::getCount()

Количество товаров в корзине:

```php
$count = Cart::getCount();
```

### 5. Config::isDev()

Проверка режима разработчика:

```php
if (Config::isDev()) {
    // Режим разработки
}
```

### 6. Request::get(), Request::post(), Request::getParam()

Удобные методы для работы с запросами:

```php
$sectionId = Request::get('SECTION_ID', 0);
$action = Request::post('action', '');
$page = Request::getParam('page', 1);
```

---

## 🔧 Обратная совместимость

Модуль `sport38.kant` полностью совместим с логикой `sport38.site`. Все методы работают аналогично, но с улучшениями:

- ✅ Более строгая типизация
- ✅ Улучшенная обработка ошибок
- ✅ Оптимизированные запросы
- ✅ Расширенный функционал

---

## 📝 Примеры использования

### В result_modifier.php

```php
<?php
if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

// Подключаем модуль
if (\Bitrix\Main\Loader::includeModule('sport38.kant')) {
    use Sport38\Kant\Price;
    use Sport38\Kant\DiscountFlag;
    
    // Получение оптимальной цены
    $optimalPrice = Price::getOptimal($arResult["PRICES"]);
    
    // Расчет скидки
    if ($optimalPrice) {
        $discountPercent = Price::calculateDiscountPercent(
            $optimalPrice["VALUE"],
            $optimalPrice["DISCOUNT_VALUE"]
        );
    }
    
    // Получение флагов скидок
    $flags = DiscountFlag::getFlagsByProduct($arResult["ID"]);
}
```

### В компонентах

```php
<?php
use Sport38\Kant\Cart;
use Sport38\Kant\Bonus;

// Проверка товара в корзине
$inCart = Cart::isInCart($productId);

// Расчет бонусов
$bonus = Bonus::calc($bonusCardId, $price, $fullPrice);
```

---

## ⚙️ Настройка

Модуль использует те же константы, что и `sport38.site`:

- `PRICE_ID` - ID типа цены
- `BONUS_CARD_IBLOCK_ID` - ID инфоблока бонусных карт
- `CITY_IBLOCK_ID` - ID инфоблока городов
- `CATALOG_IBLOCK_ID` - ID инфоблока каталога
- `OFFER_IBLOCK_ID` - ID инфоблока офферов

---

## 🆘 Откат

Если нужно вернуться к `sport38.site`:

1. В админке Bitrix отключите модуль `sport38.kant`
2. Убедитесь, что `sport38.site` установлен и активен
3. Обновите компоненты, чтобы они использовали старый namespace

---

## ✅ Чеклист миграции

- [ ] Модуль `sport38.kant` установлен
- [ ] Все обработчики событий зарегистрированы
- [ ] Компоненты обновлены для использования нового модуля
- [ ] Проверена работа цен
- [ ] Проверена работа бонусов
- [ ] Проверена работа корзины
- [ ] Все работает корректно

---

## 📚 Дополнительная информация

- Подробная документация: `/bitrix/modules/sport38.kant/README.md`
- Исходный код: `/bitrix/modules/sport38.kant/lib/`

