<?php
/**
 * Класс для работы с импортом
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class Import
{
    /**
     * Проверить, является ли это сессией импорта из 1С
     * 
     * @return bool
     */
    public static function is1CSession(): bool
    {
        return (
            ($_REQUEST["type"] ?? '') === "catalog" &&
            ($_REQUEST["mode"] ?? '') === "import"
        );
    }

    /**
     * Проверить, является ли это каталогом
     * 
     * @param int $iblockID ID инфоблока
     * @return bool
     */
    public static function isCatalog(int $iblockID): bool
    {
        return $iblockID === self::getCatalog();
    }

    /**
     * Получить ID инфоблока каталога
     * 
     * @return int ID инфоблока или 0
     */
    public static function getCatalog(): int
    {
        return defined("CATALOG_IBLOCK_ID") ? (int)CATALOG_IBLOCK_ID : 0;
    }

    /**
     * Проверить, является ли это офферами
     * 
     * @param int $iblockID ID инфоблока
     * @return bool
     */
    public static function isOffer(int $iblockID): bool
    {
        return $iblockID === self::getOffer();
    }

    /**
     * Получить ID инфоблока офферов
     * 
     * @return int ID инфоблока или 0
     */
    public static function getOffer(): int
    {
        return defined("OFFER_IBLOCK_ID") ? (int)OFFER_IBLOCK_ID : 0;
    }

    /**
     * Проверить, активна ли сессия импорта
     * 
     * @return bool
     */
    public static function isActive(): bool
    {
        return self::is1CSession();
    }
}

