<?php
/**
 * Класс для обработки свойств при импорте
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class ImportProp
{
    private static array $propAddMap = [];
    private static array $propUpdateMap = [];
    private static string $propListUserType = "sport38_list";
    private static array $exceptProp = ["USER_TYPE", "MULTIPLE_CNT"];

    /**
     * Обработка перед добавлением свойства
     * 
     * @param array $fields Поля свойства
     * @return bool|null
     */
    public static function handleBeforeAdd(array $fields)
    {
        global $APPLICATION;

        if (
            empty($fields["XML_ID"]) ||
            empty($fields["CODE"]) ||
            isset(self::$propAddMap[$fields["XML_ID"]]) ||
            !Import::is1CSession() ||
            (!Import::isCatalog((int)($fields["IBLOCK_ID"] ?? 0)) && !Import::isOffer((int)($fields["IBLOCK_ID"] ?? 0)))
        ) {
            return true;
        }

        if (!\Bitrix\Main\Loader::includeModule("iblock")) {
            $APPLICATION->throwException("Необходим модуль iblock");
            return null;
        }

        $dbProp = \CIBlockProperty::GetList(
            [],
            [
                "IBLOCK_ID" => (int)$fields["IBLOCK_ID"],
                "CODE" => $fields["CODE"],
                "PROPERTY_TYPE" => $fields["PROPERTY_TYPE"] ?? ""
            ]
        );

        if ($prop = $dbProp->Fetch()) {
            $obProp = new \CIBlockProperty;
            $obProp->Update((int)$prop["ID"], ["XML_ID" => $fields["XML_ID"]]);
            self::$propAddMap[$fields["XML_ID"]] = (int)$prop["ID"];
            return false; // Отменить добавление
        }

        return true;
    }

    /**
     * Обработка после добавления свойства
     * 
     * @param array $fields Поля свойства
     * @return void
     */
    public static function handleAfterAdd(array &$fields): void
    {
        if (
            empty($fields["RESULT"]) &&
            !empty($fields["XML_ID"]) &&
            isset(self::$propAddMap[$fields["XML_ID"]])
        ) {
            $fields["RESULT"] = self::$propAddMap[$fields["XML_ID"]];
        }
    }

    /**
     * Обработка перед обновлением свойства
     * 
     * @param array $fields Поля свойства
     * @return void
     */
    public static function handleBeforeUpdate(array &$fields): void
    {
        if (
            ($fields["PROPERTY_TYPE"] ?? "") !== "L" ||
            empty($fields["XML_ID"]) ||
            !Import::is1CSession()
        ) {
            return;
        }

        if (!\Bitrix\Main\Loader::includeModule("iblock")) {
            return;
        }

        $dbProp = \CIBlockProperty::GetList(
            [],
            ["ID" => (int)($fields["ID"] ?? 0)]
        );

        if ($prop = $dbProp->Fetch()) {
            $iblockId = (int)$prop["IBLOCK_ID"];
            if (Import::isCatalog($iblockId) || Import::isOffer($iblockId)) {
                // Логика обновления типа свойства на sport38_list
                if (($prop["USER_TYPE"] ?? "") !== self::$propListUserType) {
                    $fields["USER_TYPE"] = self::$propListUserType;
                }
            }
        }
    }

    /**
     * Обработка после обновления свойства
     * 
     * @param array $fields Поля свойства
     * @return void
     */
    public static function handleAfterUpdate(array &$fields): void
    {
        // Дополнительная логика при необходимости
    }
}

