<?php
/**
 * Основной класс модуля
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class Main
{
    private static ?array $city = null;
    private static ?int $request = null;
    private static ?int $session = null;
    private static ?int $cookie = null;
    public static string $requestVar = "cityChoose";

    /**
     * Определить город пользователя
     * 
     * @return array|false Данные города или false
     */
    public static function defineCity()
    {
        global $APPLICATION;

        $id = self::parseRequest();

        // Поиск города
        if ($id > 0) {
            $city = City::findById($id);
        } else {
            $city = City::findDefault();
        }

        if (!$city || !is_array($city)) {
            \CHTTP::SetStatus("404 Not Found");
            return false;
        }

        self::$city = $city;

        // Обновление сессии
        if ((int)$city["ID"] !== self::$session) {
            self::$session = (int)$city["ID"];
            $_SESSION[self::$requestVar] = self::$session;
        }

        // Обновление cookie
        if ((int)$city["ID"] !== self::$cookie) {
            self::$cookie = (int)$city["ID"];
            $APPLICATION->set_cookie(self::$requestVar, self::$cookie, time() + 86400 * 30); // 30 дней
        }

        // Редирект при выборе города из запроса
        if (self::$request !== null) {
            $backurl = $_REQUEST["backurl"] ?? "";
            $redirectUrl = $backurl ?: $APPLICATION->GetCurPageParam("", [self::$requestVar]);
            LocalRedirect($redirectUrl, false);
            die();
        }

        return self::$city;
    }

    /**
     * Парсинг запроса для определения города
     * 
     * @return int|null ID города или null
     */
    private static function parseRequest(): ?int
    {
        global $APPLICATION;

        // Чтение из сессии
        self::$session = isset($_SESSION[self::$requestVar]) ? (int)$_SESSION[self::$requestVar] : null;

        // Чтение из cookie
        $cookie = $APPLICATION->get_cookie(self::$requestVar);
        self::$cookie = $cookie ? (int)$cookie : null;

        // Чтение из запроса (только при валидной сессии)
        if (check_bitrix_sessid()) {
            self::$request = isset($_REQUEST[self::$requestVar]) ? (int)$_REQUEST[self::$requestVar] : null;
        }

        // Приоритет: запрос > сессия > cookie
        if (self::$request !== null && self::$request > 0) {
            return self::$request;
        }

        if (self::$session !== null && self::$session > 0) {
            return self::$session;
        }

        if (self::$cookie !== null && self::$cookie > 0) {
            return self::$cookie;
        }

        return null;
    }

    /**
     * Получить текущий город
     * 
     * @return array|false Данные города или false
     */
    public static function getCity()
    {
        return self::$city ?: false;
    }

    /**
     * Получить ID текущего города
     * 
     * @return int|null ID города или null
     */
    public static function getCityId(): ?int
    {
        return self::$city ? (int)(self::$city["ID"] ?? null) : null;
    }
}

