<?php
/**
 * Класс для работы с агентами обновления цен
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class PriceAgent
{
    /**
     * Запустить агента обновления цен
     * 
     * @param string $siteId ID сайта
     * @return void
     */
    public static function start(string $siteId = ''): void
    {
        if (empty($siteId)) {
            $siteId = SITE_ID;
        }

        $agentName = '\Sport38\Kant\PriceAgent::updatePrices("' . $siteId . '");';
        
        \CAgent::RemoveAgent($agentName, "");
        \CAgent::AddAgent(
            $agentName,
            "",
            "N",
            60,
            "",
            "Y",
            "",
            100
        );
    }

    /**
     * Добавить агента на определенное время
     * 
     * @param string $action Действие (start/stop)
     * @param string $siteId ID сайта
     * @param string $dateTime Дата и время
     * @return void
     */
    public static function addAgent(string $action, string $siteId, string $dateTime): void
    {
        $timestamp = MakeTimeStamp($dateTime);
        if ($timestamp <= time()) {
            return;
        }

        $agentName = '\Sport38\Kant\PriceAgent::updatePrices("' . $siteId . '");';
        
        \CAgent::RemoveAgent($agentName, "");
        \CAgent::AddAgent(
            $agentName,
            "",
            "N",
            $timestamp - time(),
            $dateTime,
            "Y",
            "",
            100
        );
    }

    /**
     * Обновить цены (вызывается агентом)
     * 
     * @param string $siteId ID сайта
     * @return string
     */
    public static function updatePrices(string $siteId = ''): string
    {
        if (empty($siteId)) {
            $siteId = SITE_ID;
        }

        // Логика обновления цен
        // Здесь можно добавить пакетное обновление цен
        // Пока просто возвращаем имя агента для следующего запуска

        return '\Sport38\Kant\PriceAgent::updatePrices("' . $siteId . '");';
    }

    /**
     * Остановить агента
     * 
     * @param string $siteId ID сайта
     * @return void
     */
    public static function stop(string $siteId = ''): void
    {
        if (empty($siteId)) {
            $siteId = SITE_ID;
        }

        $agentName = '\Sport38\Kant\PriceAgent::updatePrices("' . $siteId . '");';
        \CAgent::RemoveAgent($agentName, "");
    }
}

