# 🔄 Руководство по миграции PHP файлов

## 📋 Общая информация

Все адаптированные PHP файлы находятся в папке `/bitrix/templates/sport38-kant/pages/`

**ВАЖНО:** Оригинальные файлы в корне сайта **НЕ ИЗМЕНЯЮТСЯ**!

---

## 🚀 Как использовать адаптированные файлы

### Вариант 1: Ручное копирование (рекомендуется для тестирования)

1. **Сделайте backup оригинального файла:**
   ```bash
   cp /home/bitrix/www/index.php /home/bitrix/www/index.php.backup
   ```

2. **Скопируйте адаптированную версию:**
   ```bash
   cp /home/bitrix/www/bitrix/templates/sport38-kant/pages/index.php /home/bitrix/www/index.php
   ```

3. **Проверьте работу сайта**

4. **Если что-то не работает, верните оригинал:**
   ```bash
   cp /home/bitrix/www/index.php.backup /home/bitrix/www/index.php
   ```

### Вариант 2: Через настройки шаблона в Bitrix

1. Зайдите в админку Bitrix
2. Настройки → Настройки продукта → Настройки сайтов
3. Выберите ваш сайт
4. В разделе "Шаблон сайта" выберите `sport38-kant`
5. Bitrix автоматически будет использовать файлы из папки `pages/`

---

## 📁 Структура адаптированных файлов

```
/bitrix/templates/sport38-kant/pages/
├── index.php                    # Главная страница
├── catalog/
│   └── index.php                # Каталог товаров
├── personal/
│   └── cart/
│       └── index.php            # Корзина
├── contacts/
│   └── index.php                # Контакты
└── bonus/
    └── index.php                # Бонусы
```

---

## 🔄 Что изменено в адаптированных версиях

### 1. Главная страница (`index.php`)

**Изменения:**
- ✅ Компонент `bitrix:news.list` с шаблоном `ac-billboard` → `hero`
- ✅ Добавлен компонент `bitrix:news.list` с шаблоном `features` для преимуществ
- ✅ Компонент `bitrix:catalog.section.list` с шаблоном `card`
- ✅ Убраны старые CSS классы (b-module, spacing--planet и т.д.)
- ✅ Добавлены новые классы для шаблона sport38-kant

**Оригинал сохранен:** `/index.php` (не изменяется)

### 2. Каталог (`catalog/index.php`)

**Изменения:**
- ✅ Компонент `sport38:catalog` остается без изменений (использует внутренние шаблоны)
- ✅ Убраны старые CSS классы
- ✅ Добавлены новые классы для шаблона sport38-kant

**Оригинал сохранен:** `/catalog/index.php` (не изменяется)

### 3. Корзина (`personal/cart/index.php`)

**Изменения:**
- ✅ Компонент `sport38:sale.basket.basket` использует новый шаблон `.default` из sport38-kant
- ✅ Убраны старые CSS классы (js-reloader-container и т.д.)
- ✅ Добавлены новые классы для шаблона sport38-kant

**Оригинал сохранен:** `/personal/cart/index.php` (не изменяется)

### 4. Контакты (`contacts/index.php`)

**Изменения:**
- ✅ Убраны старые CSS классы (b-grid, b-module и т.д.)
- ✅ Добавлены новые классы (contacts-page, contacts-grid и т.д.)
- ✅ Структура адаптирована под новый дизайн

**Оригинал сохранен:** `/contacts/index.php` (не изменяется)

### 5. Бонусы (`bonus/index.php`)

**Изменения:**
- ✅ Убраны старые CSS классы
- ✅ Добавлены новые классы (bonus-page, bonus-info-grid и т.д.)
- ✅ Структура адаптирована под новый дизайн

**Оригинал сохранен:** `/bonus/index.php` (не изменяется)

---

## ⚙️ Настройка параметров

### IBLOCK_ID

В адаптированных файлах могут быть указаны ID инфоблоков из оригинального проекта. Проверьте и при необходимости измените:

```php
"IBLOCK_ID" => "16", // ⚠️ Укажите ваш ID инфоблока
```

### Шаблоны компонентов

Все компоненты используют шаблоны из папки `sport38-kant`:
- `bitrix:news.list` → шаблон `hero` или `features`
- `bitrix:catalog.section.list` → шаблон `card`
- `sport38:sale.basket.basket` → шаблон `.default`

---

## 🔍 Проверка после миграции

1. **Проверьте главную страницу:**
   - Hero слайдер отображается
   - Блок преимуществ работает
   - Категории товаров показываются

2. **Проверьте каталог:**
   - Товары отображаются
   - Фильтры работают
   - Пагинация работает

3. **Проверьте корзину:**
   - Товары отображаются
   - Можно изменить количество
   - Можно удалить товар

4. **Проверьте другие страницы:**
   - Контакты
   - Бонусы
   - Личный кабинет

---

## 🛠️ Откат изменений

Если что-то пошло не так:

1. **Верните оригинальный файл:**
   ```bash
   cp /home/bitrix/www/index.php.backup /home/bitrix/www/index.php
   ```

2. **Или переключите шаблон обратно на `sport38` в настройках Bitrix**

---

## 📝 Дополнительные файлы

Если нужно адаптировать другие страницы:

1. Скопируйте оригинальный файл в `/bitrix/templates/sport38-kant/pages/`
2. Адаптируйте под новый шаблон:
   - Замените старые CSS классы на новые
   - Обновите шаблоны компонентов
   - Проверьте работу

---

## ✅ Чеклист миграции

- [ ] Сделаны backup всех оригинальных файлов
- [ ] Скопированы адаптированные файлы
- [ ] Проверены IBLOCK_ID
- [ ] Проверена работа главной страницы
- [ ] Проверена работа каталога
- [ ] Проверена работа корзины
- [ ] Проверена работа других страниц
- [ ] Все работает корректно

---

## 🆘 Поддержка

Если возникли проблемы:
1. Проверьте логи ошибок PHP
2. Проверьте настройки компонентов
3. Убедитесь, что шаблон `sport38-kant` выбран в настройках Bitrix
4. Верните оригинальные файлы и проверьте, работает ли старый шаблон

