# Шаблон Sport38-Kant

Современный шаблон для Bitrix, созданный на основе дизайна kant.ru с использованием Twig.

## 📊 Статистика

- **32 CSS компонента** - полная дизайн-система
- **38 Twig шаблонов** (16 основных + 22 частичных) - все необходимые страницы
- **15+ PHP компонентов** - логика интеграции с Bitrix
- **79+ файлов** всего

## 📄 Основные страницы (16 шт)

1. **default.twig** - Главная страница
2. **catalog.twig** - Каталог товаров
3. **product-detail.twig** - Детальная страница товара
4. **cart.twig** - Корзина покупок
5. **checkout.twig** - Оформление заказа
6. **auth.twig** - Авторизация/регистрация
7. **personal.twig** - Личный кабинет
8. **contacts.twig** - Контакты
9. **search.twig** - Поиск
10. **favorites.twig** - Избранное
11. **compare.twig** - Сравнение товаров
12. **bonus.twig** - Бонусная программа
13. **text.twig** - Текстовая страница
14. **404.twig** - Ошибка 404
15. **500.twig** - Ошибка 500
16. **modal.twig** - Модальные окна

## 🎨 CSS Компоненты (32 шт)

Все необходимые компоненты для полноценного интернет-магазина:
- variables.css, base.css
- header.css, footer.css
- buttons.css, input.css
- product-card.css, catalog.css
- cart.css, checkout.css
- auth.css, personal.css
- modal.css, mobile-menu.css
- И другие...

## 🔧 Компоненты Bitrix

### Созданные компоненты:

1. **bitrix:catalog.section** (card)
   - `result_modifier.php` - преобразование данных каталога
   - `template.php` - рендеринг через Twig

2. **bitrix:catalog.element** (catalog)
   - `result_modifier.php` - преобразование данных товара
   - `template.php` - рендеринг через Twig

3. **sport38:sale.basket.basket** (.default)
   - `result_modifier.php` - преобразование данных корзины
   - `template.php` - рендеринг через Twig

4. **sport38:sale.order.ajax** (.default)
   - `result_modifier.php` - преобразование данных заказа
   - `template.php` - рендеринг через Twig

5. **bitrix:sale.personal.order** (.default)
   - `result_modifier.php` - преобразование данных заказов
   - `template.php` - рендеринг через Twig

6. **bitrix:news.list** (hero, features)
   - `result_modifier.php` - преобразование данных
   - `template.php` - рендеринг через Twig

7. **bitrix:catalog.section.list** (card)
   - `result_modifier.php` - преобразование данных категорий
   - `template.php` - рендеринг через Twig

## 📦 Вспомогательные файлы

### `include/twig_helper.php`

Класс `Sport38KantTwigHelper` с методами:
- `getTemplate()` - получить экземпляр Twig
- `display()` - отобразить шаблон
- `render()` - рендерить шаблон в строку
- `prepareBreadcrumbs()` - подготовить хлебные крошки
- `preparePrice()` - подготовить данные о цене
- `prepareImage()` - подготовить изображение

## 🚀 Использование

### В компонентах Bitrix:

```php
<?php
require_once(__DIR__ . "/../../../../include/twig_helper.php");

// Подготовка данных
$twigVars = array(
    "items" => $arResult["ITEMS"],
    "section" => $arResult["SECTION"]
);

// Рендеринг
Sport38KantTwigHelper::display("catalog.twig", $twigVars);
```

### В шаблонах страниц:

```php
<?php
require_once(__DIR__ . "/../include/twig_helper.php");

$APPLICATION->IncludeComponent(
    "bitrix:catalog.section",
    "card",
    array(
        "IBLOCK_ID" => 2,
        "SECTION_ID" => $_REQUEST["SECTION_ID"]
    )
);
```

## 📝 Структура данных для Twig

### Каталог (catalog.twig):
```php
array(
    "section" => array("ID", "NAME", "URL"),
    "items" => array(
        array("ID", "NAME", "PRICE", "IMAGE", "BADGES", ...)
    ),
    "pagination" => array("PAGES", "PREV_PAGE", "NEXT_PAGE"),
    "breadcrumbs" => array(array("TITLE", "URL"), ...)
)
```

### Товар (product-detail.twig):
```php
array(
    "product" => array(
        "ID", "NAME", "PRICE", "IMAGES", "PROPERTIES", ...
    ),
    "breadcrumbs" => array(...)
)
```

### Корзина (cart.twig):
```php
array(
    "items" => array(
        array("ID", "NAME", "QUANTITY", "PRICE", "IMAGE", ...)
    ),
    "summary" => array("SUBTOTAL", "TOTAL", "DELIVERY", ...)
)
```

## 🎯 Готовность: 100%

Дизайн полностью готов! 

### ✅ Что уже сделано:

1. ✅ **32 CSS компонента** - полная дизайн-система
2. ✅ **38 Twig шаблонов** - все необходимые страницы
3. ✅ **15+ PHP компонентов** - логика интеграции с Bitrix
4. ✅ **5 адаптированных PHP страниц** - готовы к использованию
5. ✅ **Документация** - полные руководства по интеграции и миграции

### 📋 Что нужно сделать:

1. **Мигрировать PHP файлы** (см. `MIGRATION_GUIDE.md`)
2. **Настроить параметры компонентов** (IBLOCK_ID и т.д.)
3. **Протестировать функционал**

---

## 🔄 Миграция PHP файлов

Все адаптированные PHP файлы находятся в папке `/pages/`

**ВАЖНО:** Оригинальные файлы в корне сайта **НЕ ИЗМЕНЯЮТСЯ**!

### Быстрый старт:

```bash
# Автоматическая миграция (создает backup)
cd /home/bitrix/www/bitrix/templates/sport38-kant
./migrate_pages.sh
```

Или вручную:
```bash
# Сделайте backup
cp /home/bitrix/www/index.php /home/bitrix/www/index.php.backup

# Скопируйте адаптированную версию
cp /home/bitrix/www/bitrix/templates/sport38-kant/pages/index.php /home/bitrix/www/index.php
```

Подробнее: см. `MIGRATION_GUIDE.md`

## 📚 Документация

Подробная документация по каждому компоненту находится в соответствующих файлах `result_modifier.php` и `template.php`.
