<?php
/**
 * Result modifier для детальной страницы товара
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true) die();

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "product" => array(),
    "related" => array(),
    "breadcrumbs" => array()
);

// Основная информация о товаре
$arResult["TWIG_DATA"]["product"] = array(
    "ID" => $arResult["ID"],
    "NAME" => $arResult["NAME"],
    "DETAIL_PAGE_URL" => $arResult["DETAIL_PAGE_URL"],
    "PREVIEW_TEXT" => $arResult["PREVIEW_TEXT"],
    "DETAIL_TEXT" => $arResult["DETAIL_TEXT"],
    "ARTICLE" => isset($arResult["PROPERTIES"]["CML2_ARTICLE"]["VALUE"]) ? $arResult["PROPERTIES"]["CML2_ARTICLE"]["VALUE"] : $arResult["ID"],
    "AVAILABLE" => ($arResult["CATALOG_QUANTITY"] > 0 || $arResult["CATALOG_QUANTITY"] === null),
    "QUANTITY" => $arResult["CATALOG_QUANTITY"]
);

// Изображения
$arResult["TWIG_DATA"]["product"]["IMAGES"] = array();
if (isset($arResult["MORE_PHOTO"]) && is_array($arResult["MORE_PHOTO"])) {
    foreach ($arResult["MORE_PHOTO"] as $photo) {
        if (isset($photo["SRC"])) {
            $arResult["TWIG_DATA"]["product"]["IMAGES"][] = array(
                "SRC" => $photo["SRC"],
                "SRC_SMALL" => isset($photo["SRC_SMALL"]) ? $photo["SRC_SMALL"] : $photo["SRC"],
                "ALT" => isset($photo["ALT"]) ? $photo["ALT"] : $arResult["NAME"],
                "TITLE" => isset($photo["TITLE"]) ? $photo["TITLE"] : $arResult["NAME"]
            );
        }
    }
} elseif (isset($arResult["DETAIL_PICTURE"]["SRC"])) {
    $arResult["TWIG_DATA"]["product"]["IMAGES"][] = array(
        "SRC" => $arResult["DETAIL_PICTURE"]["SRC"],
        "SRC_SMALL" => $arResult["DETAIL_PICTURE"]["SRC"],
        "ALT" => $arResult["DETAIL_PICTURE"]["ALT"] ?: $arResult["NAME"],
        "TITLE" => $arResult["DETAIL_PICTURE"]["TITLE"] ?: $arResult["NAME"]
    );
}

// Цена
if (isset($arResult["PRICE"]) && is_array($arResult["PRICE"])) {
    $price = $arResult["PRICE"];
    $arResult["TWIG_DATA"]["product"]["PRICE"] = array(
        "VALUE" => $price["VALUE"],
        "DISCOUNT_VALUE" => isset($price["DISCOUNT_VALUE"]) ? $price["DISCOUNT_VALUE"] : $price["VALUE"],
        "PRINT_VALUE" => $price["PRINT_VALUE"],
        "PRINT_DISCOUNT_VALUE" => isset($price["PRINT_DISCOUNT_VALUE"]) ? $price["PRINT_DISCOUNT_VALUE"] : $price["PRINT_VALUE"],
        "CURRENCY" => isset($price["CURRENCY"]) ? $price["CURRENCY"] : "RUB"
    );
    
    // Расчет скидки
    if ($price["VALUE"] > 0 && isset($price["DISCOUNT_VALUE"]) && $price["DISCOUNT_VALUE"] < $price["VALUE"]) {
        $discountPercent = round((($price["VALUE"] - $price["DISCOUNT_VALUE"]) * 100) / $price["VALUE"]);
        if ($discountPercent > 0 && $discountPercent < 100) {
            $arResult["TWIG_DATA"]["product"]["DISCOUNT_PERCENT"] = $discountPercent;
        }
    }
}

// Характеристики
if (isset($arResult["DISPLAY_PROPERTIES"]) && is_array($arResult["DISPLAY_PROPERTIES"])) {
    $arResult["TWIG_DATA"]["product"]["PROPERTIES"] = array();
    foreach ($arResult["DISPLAY_PROPERTIES"] as $propCode => $prop) {
        if ($propCode != "CML2_ARTICLE" && $propCode != "MORE_PHOTO") {
            $arResult["TWIG_DATA"]["product"]["PROPERTIES"][] = array(
                "CODE" => $propCode,
                "NAME" => $prop["NAME"],
                "VALUE" => is_array($prop["DISPLAY_VALUE"]) ? implode(", ", $prop["DISPLAY_VALUE"]) : $prop["DISPLAY_VALUE"]
            );
        }
    }
}

// Рейтинг и отзывы (если есть)
if (isset($arResult["PROPERTIES"]["RATING"]["VALUE"])) {
    $arResult["TWIG_DATA"]["product"]["RATING"] = floatval($arResult["PROPERTIES"]["RATING"]["VALUE"]);
}
if (isset($arResult["PROPERTIES"]["REVIEWS_COUNT"]["VALUE"])) {
    $arResult["TWIG_DATA"]["product"]["REVIEWS_COUNT"] = intval($arResult["PROPERTIES"]["REVIEWS_COUNT"]["VALUE"]);
}

// Хлебные крошки
if (isset($arResult["SECTION"]["PATH"]) && is_array($arResult["SECTION"]["PATH"])) {
    foreach ($arResult["SECTION"]["PATH"] as $path) {
        $arResult["TWIG_DATA"]["breadcrumbs"][] = array(
            "TITLE" => $path["NAME"],
            "URL" => $path["SECTION_PAGE_URL"]
        );
    }
}
$arResult["TWIG_DATA"]["breadcrumbs"][] = array(
    "TITLE" => $arResult["NAME"],
    "URL" => null
);

