<?php
/**
 * Result modifier для каталога товаров
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

// Подключаем модуль sport38.kant (если доступен)
$useKantModule = \Bitrix\Main\Loader::includeModule('sport38.kant');

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "items" => array(),
    "section" => array(),
    "pagination" => array(),
    "filters" => array()
);

// Обработка секции
if (isset($arResult["SECTION"])) {
    $arResult["TWIG_DATA"]["section"] = array(
        "ID" => $arResult["SECTION"]["ID"],
        "NAME" => $arResult["SECTION"]["NAME"],
        "DESCRIPTION" => $arResult["SECTION"]["DESCRIPTION"],
        "URL" => $arResult["SECTION"]["SECTION_PAGE_URL"]
    );
}

// Обработка товаров
if (is_array($arResult["ITEMS"]) && count($arResult["ITEMS"]) > 0) {
    foreach ($arResult["ITEMS"] as $itemKey => $item) {
        $twigItem = array(
            "ID" => $item["ID"],
            "NAME" => $item["NAME"],
            "DETAIL_PAGE_URL" => $item["DETAIL_PAGE_URL"],
            "PREVIEW_TEXT" => $item["PREVIEW_TEXT"],
            "ARTICLE" => isset($item["PROPERTIES"]["CML2_ARTICLE"]["VALUE"]) ? $item["PROPERTIES"]["CML2_ARTICLE"]["VALUE"] : $item["ID"],
            "AVAILABLE" => ($item["CATALOG_QUANTITY"] > 0 || $item["CATALOG_QUANTITY"] === null),
            "QUANTITY" => $item["CATALOG_QUANTITY"]
        );
        
        // Изображение
        if (isset($item["PREVIEW_PICTURE"]["SRC"])) {
            $twigItem["PREVIEW_PICTURE"] = array(
                "SRC" => $item["PREVIEW_PICTURE"]["SRC"],
                "ALT" => $item["PREVIEW_PICTURE"]["ALT"] ?: $item["NAME"],
                "TITLE" => $item["PREVIEW_PICTURE"]["TITLE"] ?: $item["NAME"]
            );
        } elseif (isset($item["DETAIL_PICTURE"]["SRC"])) {
            $twigItem["PREVIEW_PICTURE"] = array(
                "SRC" => $item["DETAIL_PICTURE"]["SRC"],
                "ALT" => $item["DETAIL_PICTURE"]["ALT"] ?: $item["NAME"],
                "TITLE" => $item["DETAIL_PICTURE"]["TITLE"] ?: $item["NAME"]
            );
        }
        
        // Цена (используем улучшенный метод из sport38.kant)
        if (isset($item["PRICES"]) && is_array($item["PRICES"]) && count($item["PRICES"]) > 0) {
            if ($useKantModule && class_exists('\Sport38\Kant\Price')) {
                $price = \Sport38\Kant\Price::getOptimal($item["PRICES"]);
            } else {
                $price = reset($item["PRICES"]);
            }
            
            if ($price && is_array($price)) {
                $twigItem["PRICE"] = array(
                    "VALUE" => floatval($price["VALUE"] ?? 0),
                    "DISCOUNT_VALUE" => floatval($price["DISCOUNT_VALUE"] ?? $price["VALUE"] ?? 0),
                    "PRINT_VALUE" => $price["PRINT_VALUE"] ?? "",
                    "PRINT_DISCOUNT_VALUE" => $price["PRINT_DISCOUNT_VALUE"] ?? $price["PRINT_VALUE"] ?? "",
                    "CURRENCY" => $price["CURRENCY"] ?? "RUB"
                );
                
                // Расчет скидки (используем улучшенный метод)
                if ($useKantModule && class_exists('\Sport38\Kant\Price')) {
                    $discountPercent = \Sport38\Kant\Price::calculateDiscountPercent(
                        $twigItem["PRICE"]["VALUE"],
                        $twigItem["PRICE"]["DISCOUNT_VALUE"]
                    );
                } else {
                    $discountPercent = round((($twigItem["PRICE"]["VALUE"] - $twigItem["PRICE"]["DISCOUNT_VALUE"]) * 100) / $twigItem["PRICE"]["VALUE"]);
                }
                
                if ($discountPercent > 0 && $discountPercent < 100) {
                    $twigItem["DISCOUNT"] = $discountPercent . "%";
                }
            }
        }
        
        // Бейджи (используем DiscountFlag из sport38.kant)
        $twigItem["BADGES"] = array();
        if (isset($item["PROPERTIES"]["NEWPRODUCT"]["VALUE"]) && $item["PROPERTIES"]["NEWPRODUCT"]["VALUE"] == "Y") {
            $twigItem["IS_NEW"] = true;
            $twigItem["BADGES"]["NEW"] = "NEW";
        }
        if (isset($item["PROPERTIES"]["SALELEADER"]["VALUE"]) && $item["PROPERTIES"]["SALELEADER"]["VALUE"] == "Y") {
            $twigItem["IS_HIT"] = true;
            $twigItem["BADGES"]["HIT"] = "ХИТ";
        }
        if (isset($twigItem["DISCOUNT"])) {
            $twigItem["BADGES"]["DISCOUNT"] = $twigItem["DISCOUNT"];
        }
        
        // Получить флаги скидок из модуля (если доступен)
        if ($useKantModule && class_exists('\Sport38\Kant\DiscountFlag')) {
            $discountFlags = \Sport38\Kant\DiscountFlag::getFlagsByProduct($item["ID"]);
            if ($discountFlags && is_array($discountFlags)) {
                foreach ($discountFlags as $flag) {
                    if (!isset($twigItem["BADGES"][$flag])) {
                        $twigItem["BADGES"][$flag] = $flag;
                    }
                }
            }
        }
        
        // Секции
        if (isset($item["SECTIONS"]) && is_array($item["SECTIONS"]) && count($item["SECTIONS"]) > 0) {
            $twigItem["SECTIONS"] = array();
            foreach ($item["SECTIONS"] as $section) {
                $twigItem["SECTIONS"][] = array(
                    "ID" => $section["ID"],
                    "NAME" => $section["NAME"],
                    "URL" => isset($section["SECTION_PAGE_URL"]) ? $section["SECTION_PAGE_URL"] : ""
                );
            }
        }
        
        $arResult["TWIG_DATA"]["items"][] = $twigItem;
    }
}

// Пагинация
if (isset($arResult["NAV_STRING"]) && isset($arResult["NAV_RESULT"])) {
    $arResult["TWIG_DATA"]["pagination"] = array(
        "PAGES" => array(),
        "PREV_PAGE" => null,
        "NEXT_PAGE" => null
    );
    
    if ($arResult["NAV_RESULT"]->NavPageCount > 1) {
        for ($i = 1; $i <= $arResult["NAV_RESULT"]->NavPageCount; $i++) {
            $arResult["TWIG_DATA"]["pagination"]["PAGES"][] = array(
                "NUM" => $i,
                "URL" => $arResult["NAV_RESULT"]->GetPageNavString($i),
                "CURRENT" => ($i == $arResult["NAV_RESULT"]->NavPageNomer)
            );
        }
        
        if ($arResult["NAV_RESULT"]->NavPageNomer > 1) {
            $arResult["TWIG_DATA"]["pagination"]["PREV_PAGE"] = $arResult["NAV_RESULT"]->GetPageNavString($arResult["NAV_RESULT"]->NavPageNomer - 1);
        }
        
        if ($arResult["NAV_RESULT"]->NavPageNomer < $arResult["NAV_RESULT"]->NavPageCount) {
            $arResult["TWIG_DATA"]["pagination"]["NEXT_PAGE"] = $arResult["NAV_RESULT"]->GetPageNavString($arResult["NAV_RESULT"]->NavPageNomer + 1);
        }
    }
}

// Хлебные крошки
if (isset($arResult["SECTION"]["PATH"])) {
    $arResult["TWIG_DATA"]["breadcrumbs"] = array();
    foreach ($arResult["SECTION"]["PATH"] as $path) {
        $arResult["TWIG_DATA"]["breadcrumbs"][] = array(
            "TITLE" => $path["NAME"],
            "URL" => $path["SECTION_PAGE_URL"]
        );
    }
    // Добавляем текущую секцию
    if (isset($arResult["SECTION"])) {
        $arResult["TWIG_DATA"]["breadcrumbs"][] = array(
            "TITLE" => $arResult["SECTION"]["NAME"],
            "URL" => null
        );
    }
}

