<?php
/**
 * Result modifier для блока преимуществ
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true) die();

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "features" => array()
);

// Обработка элементов
if (is_array($arResult["ITEMS"]) && count($arResult["ITEMS"]) > 0) {
    foreach ($arResult["ITEMS"] as $item) {
        $feature = array(
            "TITLE" => $item["NAME"],
            "DESCRIPTION" => isset($item["PREVIEW_TEXT"]) ? $item["PREVIEW_TEXT"] : ""
        );
        
        // Иконка из свойства или изображения
        if (isset($item["DISPLAY_PROPERTIES"]["ICON"]["VALUE"])) {
            $feature["ICON"] = $item["DISPLAY_PROPERTIES"]["ICON"]["VALUE"];
        } elseif (isset($item["PREVIEW_PICTURE"]["SRC"])) {
            $feature["ICON"] = '<img src="' . $item["PREVIEW_PICTURE"]["SRC"] . '" alt="' . htmlspecialchars($item["NAME"]) . '">';
        }
        
        $arResult["TWIG_DATA"]["features"][] = $feature;
    }
}

