<?php
/**
 * Result modifier для Hero слайдера
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true) die();

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "slides" => array()
);

// Обработка элементов
if (is_array($arResult["ITEMS"]) && count($arResult["ITEMS"]) > 0) {
    foreach ($arResult["ITEMS"] as $item) {
        $slide = array(
            "TITLE" => $item["NAME"],
            "DESCRIPTION" => isset($item["PREVIEW_TEXT"]) ? $item["PREVIEW_TEXT"] : "",
            "LINK" => isset($item["DETAIL_PAGE_URL"]) ? $item["DETAIL_PAGE_URL"] : ""
        );
        
        // Изображение
        if (isset($item["PREVIEW_PICTURE"]["SRC"])) {
            $slide["IMAGE"] = $item["PREVIEW_PICTURE"]["SRC"];
        } elseif (isset($item["DETAIL_PICTURE"]["SRC"])) {
            $slide["IMAGE"] = $item["DETAIL_PICTURE"]["SRC"];
        } elseif (isset($item["DISPLAY_PROPERTIES"]["IMAGE"]["FILE_VALUE"]["SRC"])) {
            $slide["IMAGE"] = $item["DISPLAY_PROPERTIES"]["IMAGE"]["FILE_VALUE"]["SRC"];
        }
        
        // URL из свойства
        if (isset($item["DISPLAY_PROPERTIES"]["LINK"]["VALUE"])) {
            $slide["LINK"] = $item["DISPLAY_PROPERTIES"]["LINK"]["VALUE"];
        }
        
        $arResult["TWIG_DATA"]["slides"][] = $slide;
    }
}

