<?php
/**
 * Result modifier для оформления заказа
 * Преобразует данные Bitrix в формат для Twig шаблона
 */

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

require_once(__DIR__ . "/../../../../include/twig_helper.php");

// Подготовка данных для Twig
$arResult["TWIG_DATA"] = array(
    "order" => array(),
    "user" => array(),
    "delivery" => array(),
    "payment" => array(),
    "summary" => array(),
    "breadcrumbs" => array()
);

// Данные пользователя
global $USER;
if ($USER->IsAuthorized()) {
    $arResult["TWIG_DATA"]["user"] = array(
        "ID" => $USER->GetID(),
        "NAME" => $USER->GetFirstName(),
        "LAST_NAME" => $USER->GetLastName(),
        "EMAIL" => $USER->GetEmail(),
        "PHONE" => ""
    );
}

// Итого
if (isset($arResult["ORDER_TOTAL_PRICE"])) {
    $arResult["TWIG_DATA"]["summary"] = array(
        "SUBTOTAL" => isset($arResult["ORDER_PRICE_FORMATED"]) ? $arResult["ORDER_PRICE_FORMATED"] : $arResult["ORDER_TOTAL_PRICE"],
        "DELIVERY" => isset($arResult["DELIVERY_PRICE_FORMATED"]) ? $arResult["DELIVERY_PRICE_FORMATED"] : null,
        "DISCOUNT" => isset($arResult["DISCOUNT_PRICE_FORMATED"]) ? $arResult["DISCOUNT_PRICE_FORMATED"] : null,
        "TOTAL" => isset($arResult["ORDER_TOTAL_PRICE_FORMATED"]) ? $arResult["ORDER_TOTAL_PRICE_FORMATED"] : $arResult["ORDER_TOTAL_PRICE"]
    );
}

// Хлебные крошки
$arResult["TWIG_DATA"]["breadcrumbs"] = Sport38KantTwigHelper::prepareBreadcrumbs(
    array(),
    "Оформление заказа"
);

