#!/bin/bash
#
# Скрипт для миграции PHP файлов на новый шаблон sport38-kant
# 
# ВАЖНО: Этот скрипт создает backup оригинальных файлов!
#

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PAGES_DIR="$SCRIPT_DIR/pages"
ROOT_DIR="/home/bitrix/www"
BACKUP_DIR="$ROOT_DIR/backup_$(date +%Y%m%d_%H%M%S)"

echo "🔄 Миграция PHP файлов на шаблон sport38-kant"
echo ""

# Создаем папку для backup
mkdir -p "$BACKUP_DIR"
echo "✅ Создана папка для backup: $BACKUP_DIR"
echo ""

# Функция для миграции файла
migrate_file() {
    local source_file="$1"
    local target_file="$2"
    local backup_file="$BACKUP_DIR/$(basename $(dirname $target_file))_$(basename $target_file)"
    
    if [ -f "$source_file" ]; then
        # Создаем backup
        if [ -f "$target_file" ]; then
            cp "$target_file" "$backup_file"
            echo "📦 Backup создан: $backup_file"
        fi
        
        # Создаем директорию если нужно
        mkdir -p "$(dirname $target_file)"
        
        # Копируем адаптированный файл
        cp "$source_file" "$target_file"
        echo "✅ Мигрирован: $target_file"
    else
        echo "❌ Файл не найден: $source_file"
    fi
}

# Мигрируем файлы
echo "📋 Начинаем миграцию..."
echo ""

migrate_file "$PAGES_DIR/index.php" "$ROOT_DIR/index.php"
migrate_file "$PAGES_DIR/catalog/index.php" "$ROOT_DIR/catalog/index.php"
migrate_file "$PAGES_DIR/personal/cart/index.php" "$ROOT_DIR/personal/cart/index.php"
migrate_file "$PAGES_DIR/contacts/index.php" "$ROOT_DIR/contacts/index.php"
migrate_file "$PAGES_DIR/bonus/index.php" "$ROOT_DIR/bonus/index.php"

echo ""
echo "✅ Миграция завершена!"
echo ""
echo "📦 Backup файлов находится в: $BACKUP_DIR"
echo ""
echo "⚠️  ВАЖНО: Проверьте работу сайта!"
echo "   Если что-то не работает, верните файлы из backup:"
echo "   cp $BACKUP_DIR/* /home/bitrix/www/"
echo ""

