# Модуль Sport38.Kant

Оптимизированный модуль для нового шаблона `sport38-kant`. Создан на основе `sport38.site` с улучшениями для PHP 8.1+.

## 📋 Основные улучшения

### ✅ PHP 8.1+ совместимость
- Строгая типизация (type hints)
- Улучшенная обработка null значений
- Оптимизированные запросы к БД

### ✅ Улучшенное кеширование
- Более эффективное кеширование бонусов
- Оптимизированное кеширование городов
- Улучшенная работа с ценами

### ✅ Расширенный функционал
- Дополнительные методы в классах
- Улучшенная обработка ошибок
- Более гибкая конфигурация

## 📁 Структура модуля

```
sport38.kant/
├── lib/                    # Основные классы
│   ├── price.php          # Работа с ценами (улучшено)
│   ├── bonus.php          # Бонусы (улучшено кеширование)
│   ├── cart.php           # Корзина (оптимизировано)
│   ├── city.php           # Города (улучшено)
│   ├── config.php         # Конфигурация (расширено)
│   ├── main.php           # Основной класс (улучшено)
│   ├── request.php        # HTTP запросы (расширено)
│   ├── discountFlag.php   # Флаги скидок (оптимизировано)
│   ├── priceCache.php     # Кеш цен (улучшено)
│   ├── priceAgent.php     # Агенты цен (улучшено)
│   ├── productImg.php     # Изображения (оптимизировано)
│   ├── color.php          # Цвета (улучшено)
│   ├── import.php         # Импорт (улучшено)
│   ├── importSection.php  # Импорт секций (улучшено)
│   ├── importElement.php  # Импорт элементов (улучшено)
│   ├── importAttr.php     # Импорт атрибутов (улучшено)
│   ├── importProp.php     # Импорт свойств (улучшено)
│   ├── mail.php           # Почта (улучшено)
│   └── cssInliner.php     # CSS Inliner
├── classes/
│   └── general/
│       └── property_list.php  # Тип свойства (улучшено)
├── install/
│   ├── index.php          # Установка модуля
│   └── version.php        # Версия
└── lang/
    └── ru/
        └── install/
            └── index.php   # Языковые файлы
```

## 🔄 Миграция с sport38.site

### Изменения в namespace

**Было:**
```php
use Sport38\Site\Price;
use Sport38\Site\Bonus;
```

**Стало:**
```php
use Sport38\Kant\Price;
use Sport38\Kant\Bonus;
```

### Новые методы

#### Price
- `format()` - форматирование цены
- `calculateDiscountPercent()` - расчет процента скидки

#### Bonus
- `clearCache()` - очистка кеша
- `isActiveByDate()` - проверка активности по датам

#### Cart
- `isInCart()` - проверка наличия товара
- `getCount()` - количество товаров
- `clearCache()` - очистка кеша

#### Config
- `isDev()` - проверка режима разработчика
- `getTemplateConfig()` - настройки шаблона
- `getCacheConfig()` - настройки кеша

#### Request
- `isPost()` - проверка POST запроса
- `isGet()` - проверка GET запроса
- `get()` - получить значение из REQUEST
- `post()` - получить значение из POST
- `getParam()` - получить значение из GET

## 🚀 Установка

1. Скопируйте модуль в `/bitrix/modules/sport38.kant/`
2. Зайдите в админку Bitrix
3. Настройки → Управление структурой → Управление модулями
4. Найдите "Sport38 Kant" и нажмите "Установить"

## 📝 Использование

### В компонентах

```php
<?php
use Sport38\Kant\Price;
use Sport38\Kant\Bonus;
use Sport38\Kant\Cart;

// Получить оптимальную цену
$price = Price::getOptimal($arPrices);

// Рассчитать бонусы
$bonus = Bonus::calc($bonusID, $price, $priceFull);

// Проверить товар в корзине
$inCart = Cart::isInCart($productId);
```

### В result_modifier.php

```php
<?php
if (!\Bitrix\Main\Loader::includeModule('sport38.kant')) {
    return;
}

use Sport38\Kant\Price;
use Sport38\Kant\DiscountFlag;

// Использование улучшенных методов
$optimalPrice = Price::getOptimal($item["PRICES"]);
$discountPercent = Price::calculateDiscountPercent(
    $optimalPrice["VALUE"],
    $optimalPrice["DISCOUNT_VALUE"]
);
```

## 🔧 Настройка

Модуль использует те же константы, что и `sport38.site`:
- `PRICE_ID` - ID типа цены
- `BONUS_CARD_IBLOCK_ID` - ID инфоблока бонусных карт
- `CITY_IBLOCK_ID` - ID инфоблока городов
- `CATALOG_IBLOCK_ID` - ID инфоблока каталога
- `OFFER_IBLOCK_ID` - ID инфоблока офферов

## ⚡ Производительность

- **Кеширование:** Улучшено кеширование бонусов и городов
- **Запросы:** Оптимизированы запросы к БД
- **Память:** Улучшено использование памяти
- **Ошибки:** Добавлена обработка исключений

## 🔄 Совместимость

Модуль полностью совместим с логикой `sport38.site`, но использует улучшенные методы и оптимизации.

## 📚 Документация

Подробная документация по каждому классу находится в соответствующих файлах в папке `lib/`.

