<?php
/**
 * Модуль sport38.kant
 * Оптимизированная версия для нового шаблона sport38-kant
 * 
 * @package sport38.kant
 * @version 2.0.0
 */

if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

// Явно подключаем классы свойств инфоблоков
$modulePath = __DIR__;
require_once($modulePath . '/classes/general/property_list.php');

\Bitrix\Main\Loader::registerAutoLoadClasses(
    'sport38.kant',
    array(
        // Основные классы
        '\Sport38\Kant\Config' => 'lib/config.php',
        'Sport38\Kant\Config' => 'lib/config.php',
        
        '\Sport38\Kant\Main' => 'lib/main.php',
        'Sport38\Kant\Main' => 'lib/main.php',
        
        '\Sport38\Kant\City' => 'lib/city.php',
        'Sport38\Kant\City' => 'lib/city.php',
        
        '\Sport38\Kant\Request' => 'lib/request.php',
        'Sport38\Kant\Request' => 'lib/request.php',
        
        // Работа с ценами
        '\Sport38\Kant\Price' => 'lib/price.php',
        'Sport38\Kant\Price' => 'lib/price.php',
        
        '\Sport38\Kant\PriceCache' => 'lib/priceCache.php',
        'Sport38\Kant\PriceCache' => 'lib/priceCache.php',
        
        '\Sport38\Kant\PriceAgent' => 'lib/priceAgent.php',
        'Sport38\Kant\PriceAgent' => 'lib/priceAgent.php',
        
        // Бонусы
        '\Sport38\Kant\Bonus' => 'lib/bonus.php',
        'Sport38\Kant\Bonus' => 'lib/bonus.php',
        
        // Корзина
        '\Sport38\Kant\Cart' => 'lib/cart.php',
        'Sport38\Kant\Cart' => 'lib/cart.php',
        
        // Скидки
        '\Sport38\Kant\DiscountFlag' => 'lib/discountFlag.php',
        'Sport38\Kant\DiscountFlag' => 'lib/discountFlag.php',
        
        // Работа с изображениями
        '\Sport38\Kant\ProductImg' => 'lib/productImg.php',
        'Sport38\Kant\ProductImg' => 'lib/productImg.php',
        
        // Цвета
        '\Sport38\Kant\Color' => 'lib/color.php',
        'Sport38\Kant\Color' => 'lib/color.php',
        
        // Импорт
        '\Sport38\Kant\Import' => 'lib/import.php',
        'Sport38\Kant\Import' => 'lib/import.php',
        
        '\Sport38\Kant\ImportSection' => 'lib/importSection.php',
        'Sport38\Kant\ImportSection' => 'lib/importSection.php',
        
        '\Sport38\Kant\ImportElement' => 'lib/importElement.php',
        'Sport38\Kant\ImportElement' => 'lib/importElement.php',
        
        '\Sport38\Kant\ImportAttr' => 'lib/importAttr.php',
        'Sport38\Kant\ImportAttr' => 'lib/importAttr.php',
        
        '\Sport38\Kant\ImportProp' => 'lib/importProp.php',
        'Sport38\Kant\ImportProp' => 'lib/importProp.php',
        
        // Почта
        '\Sport38\Kant\Mail' => 'lib/mail.php',
        'Sport38\Kant\Mail' => 'lib/mail.php',
        
        // CSS
        '\Sport38\Kant\CSSInliner' => 'lib/cssInliner.php',
        'Sport38\Kant\CSSInliner' => 'lib/cssInliner.php',
        
        // Классы свойств
        'CSport38KantIBlockPropertyList' => 'classes/general/property_list.php',
    )
);

