<?php
/**
 * Установка модуля sport38.kant
 * Оптимизированная версия для нового шаблона
 */

if(!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED!==true) die();

IncludeModuleLangFile(__FILE__);

class sport38_kant extends CModule
{
    public $MODULE_ID = "sport38.kant";
    public $MODULE_NAME;
    public $MODULE_DESCRIPTION;
    public $MODULE_VERSION;
    public $MODULE_VERSION_DATE;

    private array $events = [
        // Определение города
        [
            "from_module" => "main",
            "from_event" => "OnPageStart",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\Main',
            "to_method" => 'defineCity'
        ],
        // Типы свойств инфоблоков
        [
            "from_module" => "iblock",
            "from_event" => "OnIBlockPropertyBuildList",
            "to_module" => "sport38.kant",
            "to_class" => 'CSport38KantIBlockPropertyList',
            "to_method" => 'GetUserTypeDescription'
        ],
        // Кеширование цен
        [
            "from_module" => "catalog",
            "from_event" => "OnPriceAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'cache'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnPriceUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'cache'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnBeforePriceDelete",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'savePrice'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnPriceDelete",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'cache'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnProductAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'cache'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnProductUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'cache'
        ],
        // Скидки
        [
            "from_module" => "catalog",
            "from_event" => "OnDiscountAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'discountReset'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnDiscountUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'discountReset'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnDiscountDelete",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\PriceCache',
            "to_method" => 'discountReset'
        ],
        // Импорт секций
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockSectionAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportSection',
            "to_method" => 'unsetActive'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockSectionUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportSection',
            "to_method" => 'unsetActive'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnSuccessCatalogImport1C",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportSection',
            "to_method" => 'handleActive'
        ],
        // Импорт элементов
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockElementAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportAttr',
            "to_method" => 'handle'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockElementUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportAttr',
            "to_method" => 'handle'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockElementAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportElement',
            "to_method" => 'handleActive'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockElementUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportElement',
            "to_method" => 'handleActive'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockElementUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportElement',
            "to_method" => 'handleUpdate'
        ],
        // Импорт свойств
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockPropertyAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportProp',
            "to_method" => 'handleBeforeAdd'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockPropertyAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportProp',
            "to_method" => 'handleAfterAdd'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockPropertyUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportProp',
            "to_method" => 'handleBeforeUpdate'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnAfterIBlockPropertyUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ImportProp',
            "to_method" => 'handleAfterUpdate'
        ],
        // Обработка изображений
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockElementAdd",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ProductImg',
            "to_method" => 'handle'
        ],
        [
            "from_module" => "iblock",
            "from_event" => "OnBeforeIBlockElementUpdate",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\ProductImg',
            "to_method" => 'handle'
        ],
        // Почта
        [
            "from_module" => "subscribe",
            "from_event" => "BeforePostingSendMail",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\Mail',
            "to_method" => 'unsubscribeData'
        ],
        [
            "from_module" => "fileman",
            "from_event" => "OnBeforeHTMLEditorScriptsGet",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\CSSInliner',
            "to_method" => 'register'
        ],
        [
            "from_module" => "main",
            "from_event" => "OnBeforeEventSend",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\Mail',
            "to_method" => 'sent'
        ],
        // Флаги скидок
        [
            "from_module" => "catalog",
            "from_event" => "OnGetDiscount",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\DiscountFlag',
            "to_method" => 'cacheQuery'
        ],
        [
            "from_module" => "catalog",
            "from_event" => "OnGetDiscountResult",
            "to_module" => "sport38.kant",
            "to_class" => '\Sport38\Kant\DiscountFlag',
            "to_method" => 'saveResult'
        ],
    ];

    function __construct()
    {
        include(dirname(__FILE__) . "/version.php");

        if (isset($arModuleVersion) && is_array($arModuleVersion)) {
            $this->MODULE_VERSION = $arModuleVersion["VERSION"];
            $this->MODULE_VERSION_DATE = $arModuleVersion["VERSION_DATE"];
        }

        $this->MODULE_NAME = GetMessage("SPORT38_KANT_MODULE_NAME");
        $this->MODULE_DESCRIPTION = GetMessage("SPORT38_KANT_MODULE_DESCRIPTION");
    }

    function DoInstall()
    {
        foreach($this->events as $event) {
            RegisterModuleDependences(
                $event["from_module"],
                $event["from_event"],
                $event["to_module"],
                $event["to_class"],
                $event["to_method"]
            );
        }

        // Копирование файлов (если нужно)
        if (is_dir(__DIR__ . "/admin")) {
            CopyDirFiles(
                __DIR__ . "/admin",
                $_SERVER["DOCUMENT_ROOT"] . "/bitrix/admin",
                true,
                true
            );
        }

        RegisterModule($this->MODULE_ID);
    }

    function DoUninstall()
    {
        foreach($this->events as $event) {
            UnRegisterModuleDependences(
                $event["from_module"],
                $event["from_event"],
                $event["to_module"],
                $event["to_class"],
                $event["to_method"]
            );
        }

        if (is_dir(__DIR__ . "/admin")) {
            DeleteDirFiles(
                __DIR__ . "/admin",
                $_SERVER["DOCUMENT_ROOT"] . "/bitrix/admin"
            );
        }

        UnRegisterModule($this->MODULE_ID);
    }
}

