<?php
/**
 * Класс конфигурации
 * Расширенная версия с дополнительными настройками
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class Config
{
    /**
     * Определить окружение (public/dev)
     * 
     * @return string 'public' или 'dev'
     */
    public static function environment(): string
    {
        global $USER;

        // Режим разработчика через GET параметр (только для админов)
        if ($USER->IsAdmin() && isset($_REQUEST["is_dev"])) {
            $_SESSION["is_dev"] = (bool)$_REQUEST["is_dev"];
        }

        // Проверка сессии
        if (isset($_SESSION["is_dev"]) && $_SESSION["is_dev"] === true) {
            return 'dev';
        }

        // Проверка константы
        if (defined("ENVIRONMENT_ID")) {
            return ENVIRONMENT_ID;
        }

        return 'public';
    }

    /**
     * Проверить, режим разработчика ли
     * 
     * @return bool
     */
    public static function isDev(): bool
    {
        return self::environment() === 'dev';
    }

    /**
     * Получить настройки шаблона
     * 
     * @return array Массив настроек
     */
    public static function getTemplateConfig(): array
    {
        return [
            'template_id' => 'sport38-kant',
            'version' => '2.0.0',
            'cache_time' => self::isDev() ? 0 : 3600,
            'debug' => self::isDev(),
        ];
    }

    /**
     * Получить настройки кеширования
     * 
     * @return array
     */
    public static function getCacheConfig(): array
    {
        return [
            'type' => self::isDev() ? 'N' : 'A',
            'time' => self::isDev() ? 0 : 3600,
        ];
    }
}

