<?php
/**
 * Класс для обработки секций при импорте
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class ImportSection
{
    private static bool $unsetEnabled = true;

    /**
     * Убрать ACTIVE при импорте из 1С
     * 
     * @param array $fields Поля секции
     * @return void
     */
    public static function unsetActive(array &$fields): void
    {
        if (
            self::$unsetEnabled &&
            Import::is1CSession() &&
            (!isset($fields["IBLOCK_ID"]) || Import::isCatalog((int)$fields["IBLOCK_ID"]))
        ) {
            unset($fields["ACTIVE"]);
        }
    }

    /**
     * Обработать активность секций после импорта
     * 
     * @return void
     */
    public static function handleActive(): void
    {
        $catalogID = Import::getCatalog();

        if ($catalogID <= 0 || !\Bitrix\Main\Loader::includeModule("iblock")) {
            return;
        }

        self::$unsetEnabled = false;

        try {
            $db = \CIBlockSection::GetList(
                [],
                [
                    "IBLOCK_ID" => $catalogID,
                    "CNT_ACTIVE" => "Y",
                    "ELEMENT_SUBSECTIONS" => "Y"
                ],
                true,
                ["ID", "ACTIVE", "ELEMENT_CNT"]
            );

            $ob = new \CIBlockSection;
            $updateCount = 0;

            while ($section = $db->Fetch()) {
                $targetActive = ((int)($section["ELEMENT_CNT"] ?? 0) > 0) ? "Y" : "N";

                if (($section["ACTIVE"] ?? "") !== $targetActive) {
                    $ob->Update((int)$section["ID"], ["ACTIVE" => $targetActive]);
                    $updateCount++;
                }
            }

            // Логирование (если нужно)
            if ($updateCount > 0) {
                // Можно добавить логирование
            }
        } catch (\Exception $e) {
            // Обработка ошибок
        } finally {
            self::$unsetEnabled = true;
        }
    }
}


