<?php
/**
 * Класс для работы с HTTP запросами
 * Оптимизирован для PHP 8.1+
 * 
 * @package Sport38\Kant
 */

namespace Sport38\Kant;

class Request
{
    /**
     * Проверить, является ли запрос AJAX
     * 
     * @return bool
     */
    public static function isAjax(): bool
    {
        $xRequestedWith = $_SERVER['HTTP_X_REQUESTED_WITH'] ?? '';
        $requestedWith = $_REQUEST["X-Requested-With"] ?? '';
        
        return (
            strtolower($xRequestedWith) === 'xmlhttprequest' ||
            $requestedWith === "IFrame"
        );
    }

    /**
     * Проверить, является ли запрос POST
     * 
     * @return bool
     */
    public static function isPost(): bool
    {
        return ($_SERVER['REQUEST_METHOD'] ?? '') === 'POST';
    }

    /**
     * Проверить, является ли запрос GET
     * 
     * @return bool
     */
    public static function isGet(): bool
    {
        return ($_SERVER['REQUEST_METHOD'] ?? '') === 'GET';
    }

    /**
     * Получить значение из GET/POST
     * 
     * @param string $key Ключ
     * @param mixed $default Значение по умолчанию
     * @return mixed
     */
    public static function get(string $key, $default = null)
    {
        return $_REQUEST[$key] ?? $default;
    }

    /**
     * Получить значение из POST
     * 
     * @param string $key Ключ
     * @param mixed $default Значение по умолчанию
     * @return mixed
     */
    public static function post(string $key, $default = null)
    {
        return $_POST[$key] ?? $default;
    }

    /**
     * Получить значение из GET
     * 
     * @param string $key Ключ
     * @param mixed $default Значение по умолчанию
     * @return mixed
     */
    public static function getParam(string $key, $default = null)
    {
        return $_GET[$key] ?? $default;
    }
}

